\+DatabaseType Nahuatl
\ver 5.0
\desc Nahuatl lexicon from Ameyaltepec
\+mkrset 
\lngDefault English2
\mkrRecord ref

\+mkr allomorph
\nam Allomorphy in general
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr allomorph_d
\nam Dialect extension of allomorphic variation
\lng English2
\MultipleWordItems
\mkrOverThis allomorph
\-mkr

\+mkr compound
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr deleted
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr der
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr dicchange
\nam Diccionario change
\desc Sound files that have been or should be changed in the dictionary
\lng English2
\mkrOverThis ref
\-mkr

\+mkr dimin
\nam Diminutive
\desc Used when diminutive is irregular, e.g, all verbs with a diminutive had the form given here; all nouns with an irregular diminutive have it listed here. E.g. a:chi has an irregular diminutive in a:chihtsi:n, although this is not reflected in Ameyaltepec (which loses /h/) and in Oapan is only reflected in pitch accent (not reflectied in the orthography).
\lng English2
\mkrOverThis ref
\-mkr

\+mkr dis-notes
\nam Notes on what to pursue in disambiguation
\lng English2
\mkrOverThis ref
\-mkr

\+mkr disamb
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr discuss
\nam see this entry for a discussion
\lng English2
\mkrOverThis ref
\-mkr

\+mkr dt
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr ec_credit
\nam *
\desc Credit for the encyclopedia entry
\lng English2
\mkrOverThis ec_ref
\-mkr

\+mkr ec_d
\nam *
\lng English2
\mkrOverThis ec_ref
\-mkr

\+mkr ec_note
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr ec_pend
\nam *
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr ec_ref
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr fl
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr fla
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr flao
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr flo
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr gloss_e
\nam English gloss
\lng English2
\mkrOverThis ref
\mkrFollowingThis gloss_s
\-mkr

\+mkr gloss_s
\nam Spanish gloss
\lng Spanish2
\mkrOverThis ref
\-mkr

\+mkr grm
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr grmx
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr ilus_note
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr impers
\nam Impersonal forms
\desc Whether there is an impersonal in tla-, -lo, or both
\lng English2
\mkrOverThis ref
\-mkr

\+mkr impers_d
\nam Impersonal dialect forms
\lng English2
\mkrOverThis ref
\-mkr

\+mkr incorp
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr infa
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr infix
\nam Infixation
\desc Reduplication infixation, with point of infixation marked with #
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr inflx
\nam Inflection
\lng English2
\mkrOverThis ref
\-mkr

\+mkr infn
\nam *
\lng English2
\MultipleWordItems
\mkrOverThis ref
\mkrFollowingThis plural
\-mkr

\+mkr infn_irreg
\nam Irregula noun inflection
\lng English2
\mkrOverThis infn
\-mkr

\+mkr infv
\nam *
\lng Default
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr infv_d
\nam Extension of infv code
\lng English2
\mkrOverThis infv
\-mkr

\+mkr irregular
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lexical
\nam lexicalization pattern
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr lexical_d
\nam Extent of the lexicalization
\lng English2
\mkrOverThis lexical
\-mkr

\+mkr loan
\nam *
\lng English2
\mkrOverThis loan_t
\-mkr

\+mkr loan_t
\nam Type of loan
\desc This is a field that has a range of Sp (for Spanish loan), Nah (for Nahuatalized Spanish loan, e.g, ayuda:rowa) and Part (for partial loan, e.g., ta:tawe:loh).
\lng English2
\rngset Hispanicized Nahuatlized Partial Spanish 
\mkrOverThis ref
\mkrFollowingThis loan
\-mkr

\+mkr lx_rdp_Oa
\nam Reduplication status
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr lx_te
\nam Use of te
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lx_te_d
\nam Te- dialect
\desc Dialect extension of use of te- or -te-
\lng English2
\mkrOverThis lx_te
\-mkr

\+mkr lx_tsin
\nam Acceptance of diminutive
\desc Diminutive form if it exists, dialect codes Am and Oa are entered here, like for lx_te_d
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr lxam
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxam_alt
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxam_c
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxam_cpend
\nam *
\desc Citation form of audio signal, pending in that it has still not been recorded.
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxam_f
\nam Am phonetics
\desc Phonetic representation of Ameyaltepec word, if neccessary. This field will be rarely used.
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lxam_notes
\nam *
\desc Notes on Ameyaltepec lexeme. E.g., when it is documented that the lxoa form does not occur in Ameyaltepec, this field will have No Am form in it.
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr lxgen
\nam General Nahuatl dialect specified below
\desc La palabra del variante de nhuatl que se especifica en el campo siguiente.
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lxgen_d
\nam variant for which term is applicable
\desc Used codes for this. Codes are five letters
\lng English2
\rngset Ahuel Ahuep Atlia Tetel 
\mkrOverThis lxgen
\-mkr

\+mkr lxoa
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxoa-c
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lxoa_alt
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxoa_c
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxoa_cpend
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr lxoa_f
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lxoa_notes
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr lxoa_pr
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr mod
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr nde
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr nmorf
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr notes
\lng English2
\mkrOverThis ref
\-mkr

\+mkr notes_nature
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr nsem
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr nss
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr nt_col
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr nt_func
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr phrase_d
\nam *
\lng sources
\mkrOverThis phrase_n
\mkrFollowingThis phrase_e
\-mkr

\+mkr phrase_e
\nam *
\lng English2
\mkrOverThis phrase_n
\mkrFollowingThis phrase_s
\-mkr

\+mkr phrase_n
\nam *
\lng Nahuatl
\+fnt 
\Name Times New Roman
\Size 12
\Bold
\Italic
\charset 00
\rgbColor 0,128,128
\-fnt
\mkrOverThis sense_e
\mkrFollowingThis phrase_d
\-mkr

\+mkr phrase_s
\nam *
\lng Spanish2
\mkrOverThis phrase_n
\-mkr

\+mkr pitch
\nam *
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr plural
\nam Pluralization form
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr plural_d
\nam Extent of plural form
\desc Give dialect extension in the event that the plural form is irregular.
\lng English2
\mkrOverThis ref
\-mkr

\+mkr plural_irreg
\nam Irregular plural forms
\lng English2
\mkrOverThis plural_d
\-mkr

\+mkr psm
\nam *
\lng Default
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr pss
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr qry
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr qry_fon
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr qry_h
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr rdp
\nam Reduplication
\desc Pattern of reduplication documented. Also, if internal an example is given, e.g., chi:lwiwitla under rdp has Internal: <koa>chi:lw:witl</koa>
\lng English2
\mkrOverThis ref
\-mkr

\+mkr ref
\nam *
\desc This is a unique reference number for all entries. It is the required field marker for a valid entry.
\lng English2
\-mkr

\+mkr revised
\nam *
\lng Date
\mkrOverThis ref
\-mkr

\+mkr root
\nam *
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr root_notes
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr root_rel
\nam *
\desc This field is for relative nouns that are considered roots, such as -pan in kochipan.
\lng Nahuatl
\mkrOverThis ref
\-mkr

\+mkr sem
\nam *
\lng English2
\MultipleWordItems
\mkrOverThis ref
\-mkr

\+mkr sem2
\nam Semantic subfield
\desc Subfield of semantic field. For example, under house one may have : utensils and parts.
\lng English2
\MultipleWordItems
\mkrOverThis sem
\-mkr

\+mkr semref
\nam *
\lng Spanish
\mkrOverThis semref_t
\mkrFollowingThis semref_d
\-mkr

\+mkr semref_d
\nam *
\lng English2
\rngset Am Am, Oa 
\mkrOverThis semref
\-mkr

\+mkr semref_t
\nam *
\lng English2
\MultipleWordItems
\mkrOverThis ref
\mkrFollowingThis semref
\-mkr

\+mkr sense_d
\nam *
\lng sources
\mkrOverThis sense_e
\-mkr

\+mkr sense_e
\nam *
\lng English2
\+fnt 
\Name Times New Roman
\Size 12
\charset 00
\rgbColor 0,255,0
\-fnt
\mkrOverThis ref
\mkrFollowingThis sense_s
\-mkr

\+mkr sense_s
\nam *
\lng English2
\mkrOverThis sense_e
\mkrFollowingThis sense_d
\-mkr

\+mkr snd_am
\nam *
\lng sources
\+fnt 
\Name Times New Roman
\Size 11
\Bold
\charset 00
\rgbColor 0,255,0
\-fnt
\mkrOverThis phrase_n
\-mkr

\+mkr snd_oa
\nam *
\lng English2
\+fnt 
\Name Times New Roman
\Size 12
\Bold
\Italic
\charset 00
\rgbColor 0,255,0
\-fnt
\mkrOverThis phrase_n
\mkrFollowingThis src_p
\-mkr

\+mkr snd_tetel
\nam Tetelcingo sound
\desc Sound from Tetelcingo, San Juan.
\lng English2
\mkrOverThis phrase_n
\-mkr

\+mkr split
\nam Splti
\desc Any record with data in this field should be split at a later date.
\lng English2
\mkrOverThis ref
\-mkr

\+mkr src_dis
\nam source for disambiguation file
\lng English2
\mkrOverThis ref
\-mkr

\+mkr src_p
\lng sources
\mkrOverThis phrase_n
\-mkr

\+mkr src_s
\nam *
\lng English2
\mkrOverThis sense_e
\-mkr

\+mkr trans
\nam *
\lng Default
\mkrOverThis ref
\-mkr

\+mkr vease
\nam Vease
\desc Remits reader to another entry where the information is.
\lng English2
\mkrOverThis ref
\-mkr

\+mkr vl
\nam *
\lng English2
\mkrOverThis ref
\-mkr

\+mkr xref
\nam *
\lng English2
\mkrOverThis xref_t
\-mkr

\+mkr xref_d
\nam *
\lng English2
\mkrOverThis xref
\-mkr

\+mkr xref_t
\nam *
\lng English2
\rngset Stat frequent higher_valency_base minus_tla ni_base plus_tla tla_impersonal val_add_applic val_add_applic.caus val_add_caus val_reduce1 val_reduce2 verb_base 
\mkrOverThis ref
\-mkr

\-mkrset

\+rngset 
\mkr allomorph
\dat 'okowa
\dat 0=h
\dat Gender
\dat Irregular
\dat Object deletion
\dat Palatalization
\dat Plural: <kam>tio:tlakiki:ltikeh</kam>
\dat Plural: <koa>ne:xtlikh</koa>
\dat Plural: <koa>tlkikh</koa>
\dat Vowel-stem loss
\dat h=k
\dat h=l
\dat h=w
\dat i-epen
\dat s=ts
\dat x=ch
\dat y-deletion
\dat y-epenthesis
\-rngset
\+rngset 
\mkr allomorph_d
\dat Am
\dat Am, Oa
\dat Oa
\-rngset
\+rngset 
\mkr ec_pend
\dat Illustration
\dat Pending
\dat Pending: get detailed description of all palm activities.
\-rngset
\+rngset 
\mkr infn
\dat Inalienable
\dat Inalienable, Oblig poss
\dat Irregular
\dat N(loc)
\dat N-V
\dat N1
\dat N1(dom)
\dat N1(loc)
\dat N1(possessed headword)
\dat N1=N2
\dat N2
\dat N2(dom)
\dat N2(initial)
\dat N2(rdp)
\dat Oblig poss
\dat Oblig poss (1pl)
\dat Oblig poss (1pl, 2pl, 3pl)
\dat Oblig poss (1sg, 1pl)
\dat Oblig poss (3sg 3pl)
\dat Oblig poss (3sg)
\dat Oblig poss (3sg, 3pl)
\dat Oblig poss (initial)
\dat Part/whole
\dat Part/whole(only)
\dat Part/whole(rare)
\dat Spanish plural
\dat Undetermined
\-rngset
\+rngset 
\mkr infv
\dat Bound morpheme: see <klamoa>oni</klamoa>and <klamoa>tlai</klamoa>
\dat Copular
\dat Durative
\dat Durative(refl)
\dat Irregular
\dat Irregular: only in present, singular and plural all persons
\dat Irregular: see <klamoa>maka</klamoa>
\dat Irregular; <kamoa>-tikateh</kamoa>
\dat Irregular; see <klam>kukwa</klam> (Am) / <kloa>kokowa</kloa> (Oa)
\dat Irregular; see <klam>pupwa</klam> (Am) / <kloa>'popowa</kloa> (Oa)
\dat Irregular; see <klamoa>-tiw</klamoa>
\dat Irregular; see <klamoa>ita</klamoa>
\dat Irregular; see <klamoa>kah</klamoa>
\dat Irregular; see <klamoa>maka</klamoa>
\dat Irregular; see <klamoa>mati</klamoa>
\dat Irregular; see <klamoa>wa:hlaw</klamoa>
\dat Irregular; see <klamoa>yaw</klamoa>
\dat No inflections
\dat Pending (inflectional paradigm still not determined)
\dat class-1
\dat class-2a
\dat class-2b
\dat class-3a
\dat class-3a(ch)
\dat class-3a(k)
\dat class-3a(kw)
\dat class-3a(m)
\dat class-3a(ts)
\dat class-3a(w)
\dat class-3a(y)
\dat class-3b(ow)
\dat class-3c
\dat class-3c(chia)
\dat class-3c(pia)
\dat class-3d(ti)
\dat class-3d(ti); irregular
\dat class-4a
\dat class-4a(oni)
\dat class-4a(pass)
\dat class-4a/associated motion
\dat class-4b(ya-s)
\dat class-4b(ya-x)
\dat class-4c(pano)
\dat class-4d(tia)
\-rngset
\+rngset 
\mkr lexical
\dat rdp.l
\dat rdp.s
\dat rdp.s/h
\dat te-
\-rngset
\+rngset 
\mkr lx_rdp_Oa
\dat rdp.l
\dat rdp.l internal
\dat rdp.s
\dat rdp.s internal
\dat rdp.s no reduction
\dat rdp.s/h
\dat rdp.s/h internal
\dat rdp.s/h internal no reduction
\dat rdp.s/h on initial vowel
\-rngset
\+rngset 
\mkr lx_tsin
\dat Am, Oa
\dat Imperative/optative
\dat No
\dat Present
\-rngset
\+rngset 
\mkr lxam_notes
\dat Apparently this form is not used in Ameyaltepec.
\dat Check initial vowel length.
\dat Check vowel length of kaxti:ltsi:n. Cf. comments above.
\dat I have not found a parallel form in Ameyaltepec.
\dat Not found
\dat Not used
\dat Not used, see <klam>tla:lto:ntsi:n</klam>
\dat yznno
\dat yzz
\dat yzzno
\dat yzznochen
\dat yzzz
\dat yzzz*
\dat yzzzno
\dat zz
\dat zzno
\dat zzz
\dat zzz 'to translate for' and the sentence /Ne:chtlato:lkwepilia, newa xniweli mejika:noh./ 'He translates for me, I don't know Nahuatl.'
\dat zzz -#2706.
\dat zzz /Tekwi:nteyoh, pampa tetekwi:ntiw ara:doh, onye:ye:wi./ 'It (a field) is said to be <kam>tekwi:nteyoh</kam> because the plow goes bouncing along (when one plows), it repeatedly runs up against something (a barrier, in this case the rocks inside the ground).' I had these notes:"The term <kam>tekwi:nteyoh</kam> is most likely an idiosyncratic form that should later be removed from the main dictionary. It has been documented only in the speech of don Luis Lucena. Whereas others denied that this term was correct, don Luis insisted that it was proper. The embedded verbal root <kam>tekwi:n</kam> either refers to what the rocks cause the plow to do or to how the rocks scatter when hit by a plow."Cristino Flores stated that the word doesn't exist and it has been removed.
\dat zzz /kitlatlamanilia/ and /tlatlamanilia/, etc.
\dat zzz 1208...
\dat zzz <klam>a:ya:tl</klam>, <klam>tema:tlatl</klam>, or hammock)' And I had the following notes: 'Although the adjectival <kamoa>tsa:tsa:stik</kamoa> is documented in both Ameyaltepec and Oapan, Florencia Marcelino (a consultant from Oapna) stated that a transitive verbal form is not acceptable. The reason she gave was that the adjectival refers to things such as sacks and <spn>ayates</spn> that are old and have an open, wornout weave, or to cheap plastic sacks used to store chile, and that one would not want to create a material object with these characteristics.' 'The original meaning I had here was in reference to a fine, closed weave, but this is probably in error. FM indicated that the adjectival /tsa:tsa:stik/ refers to things such as sacks and ayates that are old and have an open weave; or to cheap plastic sacks for chile. She wo uld n    ot accept a verbal form, since one would not want to create something with this type of weave.'
\dat zzz Am /ilpo:tsa/ is simply x-referenced.
\dat zzz However, check whether this should be reentered.
\dat zzz However, this is not the case. Etymologically it seems related to forms such as /ne:yhka/ although my understanding is that /tlanechko/ refers to a place within sight whereas /ne:yhka/ refers to a place not visible."I added "The word should be removed from the dictionary."
\dat zzz Oapan except, I was told, when there is a big age difference. Then /po:tsi:n/ is used.
\dat zzz a back index should give all the words that are in /lxaa and /lxoa (alternate pronunciation fields) so that an electronic search is not neccessary.
\dat zzz about sth that one does not have)'
\dat zzz and it has been removed.
\dat zzz are equivalent. Note that <kam>o:kpaikniwtli</kam> is rarely found in unpossessed form.
\dat zzz as a <kam>xo:chitlame:tsi:n</kam> but everyone else said this was wrong and I have no documentation of this pronunciation from any other source.' See /xo:tlametsi:n/.
\dat zzz be the case.
\dat zzz been moved to the Am /lxa plo:weh entry.
\dat zzz best to enter this..
\dat zzz bien arrugado (particularmente la cara, en referencia a una persona)'. The question, however, is whether /pipilich/ exists as anything more than an insulting term. Can it be applied to objects or just to people? And if to people is it simply an insult (e.g., a Nahuat 'prune-face').
\dat zzz both dialects. The sound file for the headword /kwelpaxtik/, therefore, should be linked to the entry for /kwelpaxtik/, as a second utterance.
\dat zzz described.
\dat zzz entry/headwords he denied that /kwa:tlamimi:ntik/ was a word and instead gave /kwa:tlatlami:ntik/.
\dat zzz etc.) and around which the skin becomes taught and shiny'. Refers to an eye which is puffed up, from disease, a black eye, etc. and around which the skin becomes taught and shiny.
\dat zzz has shriveled up and become physically deformed inside the socket'
\dat zzz here should be numbered 1491.
\dat zzz information encoded elsewhere.
\dat zzz involves <kam>mi:tl</kam>, although this is not certain. I have never been able to elicit the absolutive form. Thus although the <kam>-w</kam> is probably the possessed marker on a stem <kam>mi:</kam>, this is not completely certain.'
\dat zzz nihneki/. This should be linked to the illustrative phrase in 423.
\dat zzz one would never say this because one never knows if the child is a boy or girl. (And perhaps even if one did know, it wouldn't be expressed in this way but rather analytically). Nevertheless, ask Am speakers about this word.
\dat zzz place.
\dat zzz resultative/stative. For this reason this entry has been removed.
\dat zzz some similar phrase.
\dat zzz stated that Am's say instead /kimailia tiotlak/ or some equivalent form. My original definition was 'to go at or start (a task such as working in the field) in the afternoon (as opposed to at the beginning of the workday)'
\dat zzz that it was a Oapan word, which it isn't.
\dat zzz the many crows that gather here.
\dat zzz this term, it is vulgar (though amusing at the same time). I have removed it from the dictionary for now.
\dat zzz to have a bottom that has given way and fallen off (e.g., of a bucket, box, etc.)' I had the following notes 'Recheck that Am /tsi:nchikipe:ltok/ is correct; perhaps it should have been /tsi:nchikipe:liwtok/ or /tsi:nchikipe:ltik/. If this entry is changed, change the x-ref under Oa /tsi:nchikipe:lihtok/ (perhaps Am has an equivalent form).'
\dat zzz uses the copula for tense/aspect inflection.
\dat zzz was a word.
\dat zzz was entered. This has been moved to the other entry, 652.
\dat zzz was given as 'to flare up (a fire)' My notes stated: 'This word is in a text I had under /ma:wa/. It should be checked as it might be in error. If so, change in all entries. Also, determine whether it is part of any paradigm, e.g. --ki/ya/lia. If so, add all entries. I might have simply made an error for /wekapania/. Check.'
\dat zzz who uttered it.
\dat zzz with alternate pronunciations. They have now been combined in one.
\dat zzz would never say this because one never knows if the child is a boy or girl. (And perhaps even if one did know, it wouldn't be expressed in this way but rather analytically). Nevertheless, ask Am speakers about this word.
\dat zzzno
\-rngset
\+rngset 
\mkr pitch
\dat yes h
\dat yes loan
\dat yes rdp.s/h
\dat yes rdp.s/h overt
\-rngset
\+rngset 
\mkr plural
\dat Final-element
\dat Initial-element
\dat Irregular
\dat Mass
\dat Plural
\dat Plural entry
\dat Regular
\dat Regular(animates)
\dat Regular-initial
\dat Regular-loan
\dat Singular
\dat Singular(concept)
\dat Singular(dom)
\dat Singular(mass)
\dat Singular(rel)
\dat Undetermined
\-rngset
\+rngset 
\mkr psm
\dat Adj
\dat Adj(ap)
\dat Adv
\dat Adv suffix
\dat Adv-interog
\dat Adv-manner
\dat Adv-place
\dat Adv-time
\dat Associated motion ending
\dat Aux
\dat Baby
\dat Call
\dat Clit
\dat Conj
\dat Coord
\dat Cuant
\dat Dem-adj
\dat Dir
\dat Discourse
\dat Dubitative
\dat Durative
\dat Durative ending
\dat Funct
\dat Greeting
\dat Interj
\dat Interrogative
\dat Loc
\dat Mod; Subord
\dat Modal
\dat N
\dat N(Proper)
\dat N(address)
\dat N(ag)
\dat N(ap)
\dat N(at)
\dat N(attributive)
\dat N(complex)
\dat N(complex/final)
\dat N(complex/initial)
\dat N(loc)
\dat N(proper)
\dat N(rel)
\dat N(truncated only)
\dat N-N
\dat N-ad
\dat N-compl
\dat N-tsi:n
\dat N/Adj
\dat N/Adj(truncated)
\dat N1
\dat N2
\dat N; Adj
\dat N; Interj
\dat Neg
\dat Nomlz
\dat Noun(rel)
\dat Num
\dat Onom
\dat PM
\dat Pr
\dat Pr(dem)
\dat Pr(demon)
\dat Pr(ind)
\dat Pr(indef)
\dat Pr(int)
\dat Pr(obj)
\dat Pr(obj); Pr(poss)
\dat Pr(pos)
\dat Pr/Adj(dem)
\dat Pr/Adj(demon)
\dat Pr?
\dat Pref(obj)
\dat Pref(pos)
\dat Pref(sub)
\dat Prefix
\dat Pronoun
\dat Quant
\dat Quotative
\dat Reltz
\dat Reltzer
\dat Reltzer (nonspecific)
\dat Stat
\dat Subord
\dat Suf
\dat Suf(adj)
\dat Suf(loc)
\dat Suf-poss
\dat Title
\dat Undeter
\dat V0
\dat V0(cop)
\dat V1
\dat V1(refl/only)
\dat V2
\dat V2(pass)
\dat V2(refl)
\dat V2(refl/dif)
\dat V2(refl/dom)
\dat V2(refl/only)
\dat V2-pass
\dat V2-refl
\dat V3
\dat V3(refl)
\dat V3(refl/only)
\dat V4
\dat function
\dat subord
\-rngset
\+rngset 
\mkr sem
\dat Age group
\dat Agriculture-planting
\dat Agriculture-tool
\dat Animal-arthropod
\dat Animal-bird
\dat Animal-body-part
\dat Animal-mammal
\dat Animal-reptile
\dat Animal-water
\dat Animal-worm
\dat Baby talk
\dat Body
\dat Clothing
\dat Color
\dat Communication
\dat Cooking-tool
\dat Dance
\dat Disease
\dat Distort
\dat Emotion
\dat Food-prepared
\dat Food-wild
\dat Frequentative
\dat Games
\dat Greeting
\dat Heavens
\dat House
\dat House-tool
\dat Kinship
\dat Maiz
\dat Maize
\dat Material culture
\dat Measure
\dat Medicinal
\dat Movement
\dat Natural phenomenon
\dat Number
\dat Personal pronoun
\dat Plant
\dat Plant-edible
\dat Plant-mushroom
\dat Plant-part
\dat Ritual term
\dat Smell
\dat Sound
\dat Supernatural
\dat Surface texture
\dat Taste sensation
\dat Topography
\dat Toponym
\dat Toy
\-rngset
\+rngset 
\mkr sem2
\dat agave
\dat agricultural
\dat amphibian
\dat animal
\dat bird
\dat body
\dat bugs/worms
\dat bush
\dat cactus
\dat color
\dat construction
\dat cook
\dat cooking
\dat cultivated
\dat domes
\dat domesticated
\dat edible
\dat fissure
\dat flower
\dat fruit
\dat herbaceous
\dat house
\dat human
\dat insect
\dat kohtli
\dat kowtli
\dat kowtsi:ntli
\dat kwawtli
\dat lizard
\dat lizzard
\dat maize
\dat mammal
\dat marine
\dat money
\dat part
\dat to:to:tl
\dat tree
\dat xiwtli
\-rngset
\+rngset 
\mkr semref_t
\dat Antonym
\dat Confer
\dat Discussion
\dat Equivalent
\dat Identical natural referent
\dat Synonym
\-rngset
\iInterlinCharWd 8
\+filset 

\+fil Adjectives
\mkr psm
\txt [#]Adj
\match_char c
\-fil

\+fil Disease
\mkr sem
\txt disease
\match_char c
\-fil

\+fil Intransitives -iwi
\mkr psm
\txt V1
\fel And
\mkr lxoa
\txt iwi[#]
\match_char c
\-fil

\+fil Lexical
\mkr lexical
\match_char c
\-fil

\+fil Nouns
\mkr psm
\txt [#]N
\match_char c
\-fil

\+fil Possessor raising
\mkr incorp
\txt N-V2
\fel And
\mkr psm
\txt V2
\match_char c
\-fil

\+fil Reflexive
\mkr psm
\txt Refl
\match_char c
\-fil

\+fil V2
\mkr psm
\txt V2
\match_char c
\-fil

\+fil Verbs 1
\mkr psm
\txt V1
\match_char c
\-fil

\+fil i-initial v2
\mkr psm
\txt V2
\fel And
\mkr lxoa
\txt [#]i
\match_char c
\-fil

\+fil ka V1
\mkr lxoa
\txt ka[#]
\fel And
\mkr infv
\txt 3
\match_char c
\-fil

\+fil pa:ki
\mkr root
\txt pa:ki
\match_char c
\-fil

\+fil pepena
\mkr root
\txt pena
\match_char c
\-fil

\-filset

\+jmpset 
\+jmp Equiva
\+mkrsubsetIncluded 
\-mkrsubsetIncluded
\+drflst 
\-drflst
\MatchWhole
\match_char c
\-jmp
\-jmpset

\+template 
\fld \revised
\fld \lxoa
\fld \lxoa_cpend
\fld \gloss_e
\fld \gloss_s
\fld \psm
\fld \infv
\fld \root
\fld \root
\-template
\mkrRecord ref
\mkrDateStamp revised
\mkrMultipleMatchShow ref
\+PrintProperties 
\header File: &f, Date: &d
\footer Page &p
\topmargin 1.00 in
\leftmargin 0.25 in
\bottommargin 1.00 in
\rightmargin 0.25 in
\recordsspace 100
\-PrintProperties
\+expset 
\MDF
\verMDF 4.1

\+expMDF Multi-Dictionary Formatter
\UTF8
\copyright Copyright  2001
\titleEnglishDiglot vernacular  English Dictionary
\titleEnglishTriglot vernacular  English  national Dictionary
\titleGlossIndexEE English  vernacular
\titleGlossIndexEN national  vernacular
\titleGlossIndexER regional  vernacular
\titleNationalDiglot vernacular  national Dictionary
\titleNationalTriglot vernacular  national  English Dictionary
\titleGlossIndexNE English  vernacular
\titleGlossIndexNN national  vernacular
\titleGlossIndexNR regional  vernacular
\exportedEnglishDiglot C:\Nahuatl General\aaaa.rtf
\cctEnglishLabels mdf_eng.cct
\dotEnglish mdf_e.dot
\cctNationalLabels mdf_inz.cct
\dotNational mdf_n.dot
\SortOnlyByLexeme
\ExcludeExamples
\ExcludeNotes
\IncludeNonMDF
\typRTF MDF Rich Text Format
\typHTML MDF SF-to-HTML
\+mkrsubsetExcluded 
\-mkrsubsetExcluded
\+rtfPageSetup 
\paperSize letter
\topMargin 0.75
\bottomMargin 1.25
\leftMargin 0.75
\rightMargin 0.75
\gutter 0.5
\headerToEdge 0.375
\footerToEdge 0.875
\columns 2
\columnSpacing 0.25
\-rtfPageSetup
\-expMDF

\+expRTF Rich Text Format
\PriKeyFieldFirst
\exportedFile C:\Backup-new\Courses\Nahuatl Summer\w initial verbs.rtf
\MarkerFont
\+mkrsubsetIncluded 
\mkr lxoa
\-mkrsubsetIncluded
\+rtfPageSetup 
\paperSize letter
\topMargin 1
\bottomMargin 1
\leftMargin 1.25
\rightMargin 1.25
\gutter 0
\headerToEdge 0.5
\footerToEdge 0.5
\columns 1
\columnSpacing 0.5
\-rtfPageSetup
\-expRTF

\+expSF Standard Format
\PriKeyFieldFirst
\exportedFile C:\Backup-new\NLE\Dictionary active version\LDC dictionary
\+mkrsubsetIncluded 
\mkr infa
\mkr infn
\mkr infv
\mkr lxoa
\mkr lxoa_alt
\mkr lxoa_c
\mkr lxoa_cpend
\mkr lxoa_pr
\mkr phrase_d
\mkr phrase_e
\mkr phrase_n
\mkr plural
\mkr psm
\mkr ref
\mkr root
\mkr sense_d
\mkr sense_e
\mkr xref
\mkr xref_d
\mkr xref_t
\-mkrsubsetIncluded
\-expSF

\+expXML XML
\PriKeyFieldFirst
\UTF8
\exportedFile C:\Backup-new\NLE\Dictionary active version\LDC dictionary for USED 2009-06-28.xml
\-expXML

\expDefault XML
\AutoOpen
\-expset
\-DatabaseType
