\+DatabaseType Metadata-log
\ver 5.0
\desc This is the final metadata control for all recordings of all languages
\+mkrset 
\lngDefault Default
\mkrRecord filename

\+mkr archive
\nam Archive location
\lng Default
\mkrOverThis filename
\-mkr

\+mkr con_age
\nam Age of contributor at time of recording
\desc Age of contributor at time of recording.
\lng Default
\mkrOverThis contributor
\-mkr

\+mkr con_origin
\nam Origin of contributor
\lng Default
\mkrOverThis contributor
\-mkr

\+mkr con_role
\nam Contributor role
\desc Role of contributor: Narrator, interviewer, etc.
\lng Default
\rngset Consultant Discussant Interviewer Musician Narrator Present 
\mkrOverThis contributor
\-mkr

\+mkr con_sex
\nam Contributor sex
\desc Male or female
\lng Default
\rngset Female Male 
\mkrOverThis contributor
\-mkr

\+mkr conage
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr conorigin
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr conrole
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr consex
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr contributor
\nam Contributor
\lng Default
\MultipleWordItems
\mkrOverThis filename
\-mkr

\+mkr date
\desc Date in traditional format yyyy-mm-dd  Note that if mm and dd are not known, use -spring, -summer, -fall, and -winter
\lng Default
\mkrOverThis recordby
\-mkr

\+mkr descrip
\nam Description
\desc Description of text
\lng Default
\mkrOverThis genre
\-mkr

\+mkr duration
\nam Duration
\desc Duration in 000:00  min : sec
\lng Default
\mkrOverThis filename
\-mkr

\+mkr encyxref
\nam Encyclopedia
\desc Links to specific words in the lexicon: headword and UID; multiple links separated by semicolon.
\lng Default
\mkrOverThis filename
\-mkr

\+mkr filename
\lng Default
\-mkr

\+mkr filepast
\nam Past file names
\desc If the filename has been standardized, this is a list of all previous filenames
\lng Default
\mkrOverThis filename
\-mkr

\+mkr folder
\nam Folder
\desc General location of the documents associated with this file
\lng Default
\mkrOverThis filename
\-mkr

\+mkr formatname
\lng Default
\mkrOverThis timecoded
\-mkr

\+mkr genre
\nam Genre
\lng Default
\MultipleWordItems
\mkrOverThis filename
\-mkr

\+mkr language
\nam Language
\desc General language name, e.g., Nahuatl, Mixtec, etc.
\lng Default
\rngset Mixtec Nahuatl Totonac 
\mkrOverThis filename
\-mkr

\+mkr lg_code
\nam ISO code
\desc This is the ISO 639-3 code for the language
\lng Default
\rngset ngu xty 
\mkrOverThis language
\-mkr

\+mkr lg_coor
\nam Coordinates
\desc Latitude and longitude of village from where recordings derive
\lng Default
\mkrOverThis language
\-mkr

\+mkr lg_country
\nam Language country
\desc Country of language, for now always Mexico.
\lng Default
\rngset Mexico 
\mkrOverThis language
\CharStyle
\-mkr

\+mkr lg_mpio
\nam Municipio
\desc Municipio where village of origin is located.
\lng Default
\mkrOverThis language
\-mkr

\+mkr lg_state
\nam Language state
\desc State from where the language is.
\lng Default
\MultipleWordItems
\mkrOverThis language
\-mkr

\+mkr lg_var
\desc Language variant
\lng Default
\MultipleWordItems
\mkrOverThis language
\-mkr

\+mkr lg_vil
\nam Language village
\desc This is the village from where the recording comes
\lng Default
\mkrOverThis language
\-mkr

\+mkr lgcode
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr lgcoor
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr lgcountry
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr lgmpio
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr lgstate
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr lgvar
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr lgvil
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr notes
\nam Notes
\desc Any notes about the text, transcription, etc.
\lng Default
\mkrOverThis filename
\-mkr

\+mkr project
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr rec_format
\nam Recording format
\desc Sampling rate / bit rate
\lng Default
\mkrOverThis recordby
\-mkr

\+mkr rec_hist
\nam Recording history
\desc Recording history, i.e., when digitized, etc.
\lng Default
\mkrOverThis recordby
\-mkr

\+mkr rec_machine
\nam Recorder used
\desc This is the recording device used, e.g., Sonifex Courier, Marantz, etc.
\lng Default
\+fnt 
\Name Times New Roman
\Size 12
\rgbColor 0,0,0
\-fnt
\mkrOverThis recordby
\-mkr

\+mkr rec_mike
\nam Recording microphone
\desc This is the microphone used, e.g., ATM-75
\lng Default
\mkrOverThis recordby
\-mkr

\+mkr rec_orig
\nam Recording original
\desc If not recorded digitally, then nature of original recording (minidisk, cassette, reel-to-reel, etc.)
\lng Default
\mkrOverThis recordby
\-mkr

\+mkr rec_power
\nam Power source
\lng Default
\rngset AC DC 
\mkrOverThis recordby
\-mkr

\+mkr recformat
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr rechist
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr recmachine
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr recmike
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr recordby
\nam Recorded by
\desc Person who did recording (i.e., who managed the recording session)
\lng Default
\MultipleWordItems
\mkrOverThis filename
\-mkr

\+mkr recorig
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr recpower
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr ref
\nam Data of data entry
\lng English2
\MultipleWordItems
\mkrOverThis filename
\-mkr

\+mkr reimport
\nam Reimported
\lng Default
\mkrOverThis timecoded
\-mkr

\+mkr revisado
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr rights
\nam Rights status
\lng Default
\mkrOverThis filename
\-mkr

\+mkr size
\nam Size
\desc Size in kilobytes
\lng Default
\mkrOverThis filename
\-mkr

\+mkr status
\nam Status
\lng Default
\mkrOverThis timecoded
\-mkr

\+mkr statusdate
\nam Date of last status report
\lng Default
\mkrOverThis timecoded
\-mkr

\+mkr subgenre
\nam Subgenre
\lng Default
\MultipleWordItems
\mkrOverThis genre
\-mkr

\+mkr timecoded
\nam Timecoded transcription
\lng Default
\mkrOverThis filename
\-mkr

\+mkr tit_eng
\nam Title in English
\lng Default
\mkrOverThis genre
\-mkr

\+mkr tit_indigenous
\nam Title in native language
\desc Title in native language, if relevant (i.e., a story)
\lng Default
\mkrOverThis genre
\-mkr

\+mkr tit_spn
\nam Title Spanish
\lng Default
\mkrOverThis genre
\-mkr

\+mkr titeng
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr titnative
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr titspn
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\+mkr track
\nam Track
\desc Track on which
\lng Default
\MultipleWordItems
\mkrOverThis contributor
\-mkr

\+mkr tracks
\nam Tracks
\desc Stereo or mono
\lng Default
\MultipleWordItems
\mkrOverThis recordby
\-mkr

\+mkr transby
\nam Transcribed by
\lng Default
\mkrOverThis timecoded
\-mkr

\+mkr uid
\nam Unique ID
\desc Unique ID  Format is yyyy-mm-dd-a/b/c etc.
\lng Default
\mkrOverThis filename
\-mkr

\+mkr wordcount
\nam Words
\desc Number of words in transcribed document
\lng Default
\mkrOverThis filename
\-mkr

\+mkr words
\nam *
\lng Default
\mkrOverThis filename
\-mkr

\-mkrset

\+rngset 
\mkr contributor
\dat Amith, Jonathan D
\dat Barrera Camilo, Rutilia
\dat Barrera Esteva, Rutilia
\dat Cabrera Ortiz, Jeremas
\dat Cabrera Timoteo, Eufenia
\dat Carmen Santos, Andrs Ciriaco
\dat Carrisal Calaquino, Pedro
\dat Castillo Garca, Esteban
\dat Castillo Garca, Rey
\dat Castillo Pantalen, Pedro
\dat Castillo Vzquez, Simn
\dat Celedonio, Miguel
\dat Cenario Corts, Alejandrino
\dat Cenario, Alejandro
\dat Domnguez Damin, Vicente
\dat Domnguez, Vicente
\dat Encarnacin Gertrudis, Marcelina
\dat Felipe Alonso, Luis
\dat Felipe Leyva, Emilia
\dat Francisco Gonzlez, Maximiliano
\dat Galicia Castro, Arnulfa
\dat Garca Bautista, Soledad
\dat Garca Santiago, Lamberto
\dat Guadalupe Sierra, Esteban
\dat Guadalupe Sierra, Zoila
\dat Hernandez Pacheco, Pedro
\dat Margarito Damin, Juan
\dat Meza Teodoro, Maximino
\dat Nazario Sotero, Guillermina
\dat Nio Leonardo, Fernando
\dat Pantalen Barrera, Paula
\dat Pantalen Esteva, Silvestre
\dat Pinzn, Jess
\dat Prisciliano, Alberto
\dat Ramos Rmulo, Victorino
\dat Ramrez Cayetano, Juvenal
\dat Ramrez, Juana
\dat Rmulo Santiago, Carlos
\dat Salazar Felipe, Mario
\dat Santiago Castillo, Estela
\dat Severiano Germn, Martn
\dat Tecoapa Snchez, Eligia
\dat Teodoro Bautista, Constantino
\dat Teodoro Celso, Constantino
\dat Vazquez Herculano, Luis
\dat Vernico Gonzlez, Pedro
\dat Vernico, Pedro
\dat Vzquez Herculano, Luis
\-rngset
\+rngset 
\mkr genre
\dat Elicitation
\dat Ethnography
\dat Lexicon
\dat Linguistic
\dat Material culture
\dat Music
\dat Music and narration
\dat Narration
\dat Prayer
\dat Ritual speech
\-rngset
\+rngset 
\mkr lg_state
\dat Guerrero
\dat Puebla
\dat Veracruz
\-rngset
\+rngset 
\mkr lg_var
\dat Balsas Nahuatl
\dat Chilapa-Tixtla
\dat Costa Guerrero
\dat Northern Veracruz Nahuatl
\dat Sierra Norte de Puebla
\dat Sierra Norte de Puebla Nahuatl
\dat Sierra Norte de Puebla Totonac
\dat Southern Guerrero Nahuatl
\-rngset
\+rngset 
\mkr recordby
\dat Amith, Jonathan D
\dat Amith, Jonathan D.
\dat Cabrera Ortiz, Jeremas
\-rngset
\+rngset 
\mkr subgenre
\dat Agriculture
\dat Astronomy
\dat Botany : functions
\dat Botany : plants
\dat Botany : trees
\dat Bride asking
\dat Bridge asking
\dat Catholic
\dat Children : games
\dat Danzas
\dat Disease
\dat Fiestas :
\dat Food
\dat Heavens
\dat Lexicon : sense expansion
\dat Lexicon : word discussions
\dat Life history : childhood
\dat Life history : general
\dat Life history : migration
\dat Linguistic : general description
\dat Linguistic : reduplication
\dat Linguistic : tense/aspect
\dat Material culture
\dat Material culture :
\dat Music type :
\dat Music type : Danzas
\dat Music type : Popular
\dat Music type : Traditional
\dat Natural phenomenon
\dat Rain petition
\dat Stories : adult
\dat Stories : animals
\dat Stories : general
\dat Stories : religious
\dat Tonal patterns
\dat Traditional beliefs
\dat Village history
\dat Zoology : arthropods
\dat Zoology : birds
\dat Zoology : fish
\dat Zoology : invertebrates
\dat Zoology : mammals
\dat Zoology : reptiles
\-rngset
\+rngset 
\mkr track
\dat Left
\dat Right
\dat mono
\dat no utterances
\-rngset
\+rngset 
\mkr tracks
\dat mono
\dat mono (converted from stereo)
\dat stereo
\-rngset
\iInterlinCharWd 8
\+filset 

\+fil Elicit
\mkr filename
\txt Yolox_Elict
\match_char c
\-fil

\+fil Jeremias recordings
\mkr recordby
\txt Cabrera
\match_char c
\-fil

\+fil Juvenal Ramirez
\mkr filename
\txt Juvenal
\match_char c
\-fil

\+fil Pedro Hernandez
\mkr filename
\txt Pedro-Hernandez
\match_char c
\-fil

\+fil Victorino Ramos
\mkr contributor
\txt Victorino
\match_char c
\-fil

\+fil Village Acatlan
\mkr lg_vil
\txt Acatl
\match_char c
\-fil

\-filset

\+jmpset 
\-jmpset

\+template 
\fld \uid 2010-12-xx-x
\fld \filepast
\fld \folder Zoology
\fld \duration 00x:xx
\fld \size xx,xxx kb
\fld \wordcount
\fld \encyxref None
\fld \language Mixtec
\fld \lg_var Costa Guerrero
\fld \lg_code xty
\fld \lgvil Yoloxchitl
\fld \lgcoor 16 48' 59" N, 98 41' 12" W
\fld \lgmpio San Luis Acatln
\fld \lgstate Guerrero
\fld \lgcountry Mxico
\fld \recordby Amith, Jonathan D.
\fld \date 2010-12-xx
\fld \tracks stereo
\fld \recformat 48 KHz / 16-bit
\fld \recorig digital
\fld \rechist
\fld \recmachine Marantz PMD 670
\fld \recmike Shure SM10a
\fld \recpower
\fld \contributor xxx
\fld \conrole Consultant
\fld \consex Male
\fld \conorigin Yoloxchitl
\fld \conage
\fld \track Left
\fld \contributor Castillo Garca, Rey
\fld \conrole Entrevistador
\fld \consex Male
\fld \conorigin Yoloxchitl
\fld \conage
\fld \track Right
\fld \genre Ethnography
\fld \subgenre Zoology : arthropods
\fld \titnative
\fld \titeng
\fld \titspn
\fld \descrip
\fld \timecoded
\fld \transby
\fld \formatname
\fld \reimport
\fld \status
\fld \statusdate
\fld \rights Explicado y aceptado por escrito
\fld \archive
\fld \ref 29/Dec/2010
\-template
\mkrRecord filename
\mkrDateStamp ref
\+PrintProperties 
\header File: &f, Date: &d
\footer Page &p
\topmargin 1.00 in
\leftmargin 0.25 in
\bottommargin 1.00 in
\rightmargin 0.25 in
\recordsspace 10
\-PrintProperties
\+expset 

\+expRTF Rich Text Format
\+rtfPageSetup 
\paperSize letter
\topMargin 1
\bottomMargin 1
\leftMargin 1.25
\rightMargin 1.25
\gutter 0
\headerToEdge 0.5
\footerToEdge 0.5
\columns 1
\columnSpacing 0.5
\-rtfPageSetup
\-expRTF

\+expSF Standard Format
\exportedFile F:\Mixtec Yoloxochitl\Sonidos\Elicitation-2010-12\Lista de archivos
\+mkrsubsetIncluded 
\mkr filename
\-mkrsubsetIncluded
\-expSF

\+expXML XML
\UTF8
\exportedFile E:\Mixtec Yoloxochitl\Log and consultant dabases\Metadata-Mixtec-audio_maestro_2011-01-09.xml
\-expXML

\expDefault XML
\CurrentWindow
\-expset
\-DatabaseType
